uniform sampler2D image;

uniform float factor;

void main()
{
    vec2 blurCoords = gl_TexCoord[0].xy;
    

    
    vec4 blur1 = texture2D(image, blurCoords + vec2(-factor,0.0));
    vec4 blur2 = texture2D(image, blurCoords + vec2(factor,0.0));
    vec4 blur3 = texture2D(image, blurCoords + vec2(0.0,-factor));
    vec4 blur4 = texture2D(image, blurCoords + vec2(0.0,factor));
    
    vec4 blurColor = (blur1 + blur2 + blur3 + blur4) / 4.0;

	gl_FragColor = blurColor;
}
